#########################################################################################
#   License                                                                             #
#                                                                                       #
#   Copyright © 2018, Numato Systems Private Limited. All rights reserved.              #
#                                                                                       #
#   This software including all supplied files, Intellectual Property, know-how         #
#   Or part of thereof as applicable (collectively called SOFTWARE) in source           #
#   And/Or binary form with accompanying documentation Is licensed to you by            #
#   Numato Systems Private Limited (LICENSOR) subject To the following conditions.      #
#                                                                                       #
#   1. This license permits perpetual use of the SOFTWARE if all conditions in this     #
#       license are met. This license stands revoked In the Event Of breach Of any      #
#       of the conditions.                                                              #
#   2. You may use, modify, copy the SOFTWARE within your organization. This            #
#       SOFTWARE shall Not be transferred To third parties In any form except           #
#       fully compiled binary form As part Of your final application.                   #
#   3. This SOFTWARE Is licensed only to be used in connection with/executed on         #
#       supported products manufactured by Numato Systems Private Limited.              #
#       Using/ executing this SOFTWARE On/In connection With custom Or third party      #
#       hardware without the LICENSORs prior written permission Is expressly            #
#       prohibited.                                                                     #
#   4. You may Not download Or otherwise secure a copy of this SOFTWARE for the         #
#       purpose of competing with Numato Systems Private Limited Or subsidiaries in     #
#       any way such As but Not limited To sharing the SOFTWARE With competitors,       #
#       reverse engineering etc... You may Not Do so even If you have no gain           #
#       financial Or otherwise from such action.                                        #
#   5. DISCLAIMER                                                                       #
#   5.1. USING THIS SOFTWARE Is VOLUNTARY And OPTIONAL. NO PART OF THIS SOFTWARE        #
#       CONSTITUTE A PRODUCT Or PART Of PRODUCT SOLD BY THE LICENSOR.                   #
#   5.2. THIS SOFTWARE And DOCUMENTATION ARE PROVIDED “AS IS” WITH ALL FAULTS,          #
#       DEFECTS And ERRORS And WITHOUT WARRANTY OF ANY KIND.                            #
#   5.3. THE LICENSOR DISCLAIMS ALL WARRANTIES EITHER EXPRESS Or IMPLIED, INCLUDING     #
#       WITHOUT LIMITATION, ANY WARRANTY Of MERCHANTABILITY Or FITNESS For ANY          #
#       PURPOSE.                                                                        #
#   5.4. IN NO EVENT, SHALL THE LICENSOR, IT'S PARTNERS OR DISTRIBUTORS BE LIABLE OR    #
#       OBLIGATED FOR ANY DAMAGES, EXPENSES, COSTS, LOSS Of MONEY, LOSS OF TANGIBLE     #
#       Or INTANGIBLE ASSETS DIRECT Or INDIRECT UNDER ANY LEGAL ARGUMENT SUCH AS BUT    #
#       Not LIMITED TO CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH     #
#       OF WARRANTY Or ANY OTHER SIMILAR LEGAL DEFINITION.                              #
#########################################################################################

#   Ruby code demonstrating basic Relay features Of Numato Lab Ethernet Relay Module.

#########################################################################################
#                                                                                       #
#                                   Prerequisites                                       #
#                                   -------------                                       #
#                                 install Ruby Installer                                #
#                                                                                       #
#########################################################################################

require 'net/telnet'

$host = "169.254.1.1"                                       #Device IP Address
$user = "admin"                                             #Device Telnet User Name
$pass = "admin"                                             #Device Telnet Password

#Connect to device with user provided credentials
def connect
    $telnet_obj = Net::Telnet::new("Host" => $host,
                                 "Port" => 23,
                                 "Timeout" => 10,
                                 "Prompt" => /User Name: /,
                                 "Output_log"=>"output_log.log", 
                                 "Dump_log"=>"dump_log.log")

    $telnet_obj.cmd("String" => $user)
    $login =  $telnet_obj.cmd("String" => "   " + $pass, "Match" => />>/)  { |c| print c.tr('>', '') }
    puts "----------------------"
end

connect()
relay_number = "2"                                          #Change the Relay Number here when required

if relay_number.match(/^[a-v]*$/)
    relay_number = relay_number.upcase                      #Converts the relay_number(A to V) to upper case if user entered it as lower case.
end

#########################################################################################

#Relay ON
$telnet_obj.cmd("String" => "relay on " + relay_number, "Match" => />/) { |c| print c.tr('>', '') }
puts "\nRelay ON " + relay_number
sleep(1)    
#########################################################################################

#Relay read
print "\nRelay read ", relay_number, " : "
$telnet_obj.cmd("String" => "relay read " + relay_number, "Match" => />/) { |c| print c.tr('>', '') }
sleep(1)
#########################################################################################

#Relay OFF
$telnet_obj.cmd("String" => "relay off " + relay_number, "Match" => />/) { |c| print c.tr('>', '') }
puts "\nRelay OFF " + relay_number
sleep(1)
#########################################################################################

#Relay readread
print "\nRelay read ", relay_number, " : "
$result = $telnet_obj.cmd("String" => "relay read " + relay_number, "Match" => />/) { |c| print c.tr('>', '') }
sleep(1)
#########################################################################################

#Finally close the TELNET session before exiting
$telnet_obj.close


